/*
 * Decompiled with CFR 0.152.
 */
package com.roguewave.chart.richtext.v2_1;

import com.roguewave.chart.core.v2_1.graphics.Canvas3D;
import com.roguewave.chart.core.v2_1.graphics.Drawable;
import com.roguewave.chart.core.v2_1.graphics.RelativePlacement;
import com.roguewave.chart.richtext.v2_1.BlockContext;
import com.roguewave.chart.richtext.v2_1.TextBlock;
import java.awt.Graphics;

public class TextBlockDrawable
implements Drawable,
RelativePlacement {
    TextBlock block_;
    int x_;
    int y_;
    int align_;

    public TextBlockDrawable(TextBlock block, int x, int y, int align) {
        this.block_ = block;
        this.x_ = x;
        this.y_ = y;
        this.align_ = align;
    }

    public void drawOn(Canvas3D canvas, Graphics g) {
        BlockContext bc = new BlockContext(this.x_, this.y_, g);
        int width = this.block_.getWidth(bc);
        switch (this.align_) {
            case 3: {
                bc.setX(this.x_ - this.block_.getWidth(bc) / 2);
                bc.setY(this.y_ - this.block_.getAscent(bc));
                break;
            }
            case 0: {
                bc.setX(this.x_ - width / 2);
                break;
            }
            case 1: {
                bc.setX(this.x_ - this.block_.getWidth(bc));
                bc.setY(this.y_ - this.block_.getAscent(bc) / 2);
                break;
            }
            case 2: {
                bc.setY(this.y_ - this.block_.getAscent(bc) / 2);
                break;
            }
            case 6: {
                break;
            }
            default: {
                System.err.println("TextBlockDrawable: Bad or unimplemented placement specification");
                return;
            }
        }
        this.block_.render(bc);
    }
}

